#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

vec4 INPUTSRC(image2d_t src_data,__global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc);
}

float Sample(image2d_t src_data, __global FilterParam* param, vec2 uv)
{
    vec4 color = INPUTSRC(src_data, param, uv);
    return dot(color.rgb, (vec3)(0.114f, 0.587f, 0.299f));
}

vec2 SobelFilter(image2d_t src_data, __global FilterParam* param, vec2 uv, vec2 resolution)
{
	float factor = resolution.y / 433.0f;
	
    float tl = Sample(src_data, param, uv + ((vec2)(-1.0f, 1.0f)/resolution.xy) * factor);
    float tc = Sample(src_data, param, uv + ((vec2)(0.0f, 1.0f)/resolution.xy) * factor);
    float tr = Sample(src_data, param, uv + ((vec2)(1.0f, 1.0f)/resolution.xy) * factor);
    
    float l = Sample(src_data, param, uv + ((vec2)(-1.0f, 0.0f)/resolution.xy) * factor);
    float c = Sample(src_data, param, uv + ((vec2)(0.0f, 0.0f)/resolution.xy) * factor);
    float r = Sample(src_data, param, uv + ((vec2)(1.0f, 0.0f)/resolution.xy) * factor);
    
    float bl = Sample(src_data, param, uv + ((vec2)(-1.0f, -1.0f)/resolution.xy) * factor);
    float bc = Sample(src_data, param, uv + ((vec2)(0.0f, -1.0f)/resolution.xy) * factor);
    float br = Sample(src_data, param, uv + ((vec2)(1.0f, -1.0f)/resolution.xy) * factor);
    
    float gx = tl - tr + 2.0f * l - 2.0f * r + bl - br;
    float gy = -tl - 2.0f * tc - tr + bl + 2.0f * bc + br;
    
    return (vec2)(gx, gy);
}

__kernel void MAIN(
      __read_only image2d_t src_data,
      __write_only image2d_t dest_data,        //Data in global memory
      __global FilterParam* param,
	  int alpha,
	  int color)
{	
	int W = get_global_size(0);
	int H = get_global_size(1);
	
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 resolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 tc = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f))/resolution.xy;
	
	int red = (color >> 16) & 0xff;
	int green = (color >> 8) & 0xff;
	int blue = color & 0xff;
	
	vec4 orig = INPUTSRC(src_data, param, tc);
     
	vec2 sobelFilter = SobelFilter(src_data, param, tc, resolution);
    float gradient = sobelFilter.x * sobelFilter.x + sobelFilter.y * sobelFilter.y;
     
	vec3 inputColor = (vec3)((float)(red), (float)(green), (float)(blue)) / 255.0f;
	
	inputColor.xyz = step(0.0000001f, inputColor.x + inputColor.y + inputColor.z) * (inputColor.xyz - (vec3)(-0.2f)) + (vec3)(-0.2f);
	
	vec4 retColor = (vec4)(0.0f);
	retColor.xyz = orig.xyz + inputColor.xyz * gradient;
	retColor.xyz = clamp(retColor.xyz, 0.0f, 1.0f);
	retColor = mix(orig,retColor,(float)(alpha)/100.0f);
	retColor.w = orig.w;
	
    write_imagef(dest_data, gl_FragCoord, retColor);
}


    